package pl.model.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.persistence.EntityManager;

import pl.ctrl.AuthorController;
import pl.model.Author;

@FacesConverter( value="AuthorConverter")
public class AuthorConverter implements Converter {
  @Override
  public Object getAsObject( FacesContext context, UIComponent component,
      String value) {
    AuthorController ac = FacesContext
        .getCurrentInstance()
        .getApplication()
        .evaluateExpressionGet( context, "#{authorCtrl}",
            AuthorController.class);
    EntityManager em = ac.getEntityManager();
    if ( value == null) {
      return null;
    }
    return em.find( Author.class, Integer.parseInt( value));
  }

  @Override
  public String getAsString( FacesContext context, UIComponent component,
      Object value) {
    if ( value == null) {
      return null;
    } else if ( value instanceof Author) {
      return Integer.toString( ((Author) value).getPersonId());
    }
    return null;
  }
}