package pl.model;

public enum BookTypeEL {
  TEXTBOOK( "TextBook"), 
  BIOGRAPHY( "Biography");

  // associated label for an enumeration literal
  private final String label;

  /**
   * Constructor which allows to create literals with associated labels.
   * 
   * @param label
   *          the associated label for the enumeration literal
   */
  private BookTypeEL( String label) {
    this.label = label;
  }

  /**
   * Get the label value for the enumeration literal.
   * 
   * @return the label value
   */
  public String getLabel() {
    return this.label;
  }
}