package pl.ctrl;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;

import pl.model.TextBook;

@SessionScoped @ManagedBean( name="textBookCtrl")
public class TextBookController {
  @PersistenceContext( unitName="SubtypingApp")
  private EntityManager em;
  @Resource private UserTransaction ut;

  /**
   * Create and persist a new Book instance.
   * 
   * @param isbn
   *          the isbn of the book to create
   * @param title
   *          the title of the book to create
   * @param year
   *          the year of the book to create
   * @param subjectArea
   *          the subject area of the book to create
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String add( String isbn, String title, Integer year, String subjectArea) {
    try {
      TextBook.add( em, ut, isbn, title, year, subjectArea);
      // Enforce clearing the form after creating the Book row.
      // Without this, the form will show the latest completed data
      FacesContext facesContext = FacesContext.getCurrentInstance();
      facesContext.getExternalContext().getRequestMap().remove( "book");
      facesContext.getExternalContext().getRequestMap().remove( "textBook");
      facesContext.getExternalContext().getRequestMap()
          .remove( "biographyBook");
    } catch ( EntityExistsException e) {
      try {
        ut.rollback();
      } catch ( Exception e1) {
        e1.printStackTrace();
      }
      e.printStackTrace();
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "create";
  }

  /**
   * Update a Book instance.
   * 
   * @param isbn
   *          the isbn of the book to update (the book will be identified in the
   *          database by using this value)
   * @param title
   *          the new value for the title property
   * @param year
   *          the new value for the year property
   * @param subjectArea
   *          the new value for the subjectArea property
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String update( String isbn, String title, Integer year,
      String subjectArea) {
    try {
      TextBook.update( em, ut, isbn, title, year, subjectArea);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "update";
  }

  /**
   * Delete a Book entry from database.
   * 
   * @param isbn
   *          the isbn of the book to delete - used to uniquely identify the
   *          book entry.
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String destroy( String isbn) {
    try {
      TextBook.destroy( em, ut, isbn);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "delete";
  }
}
