package pl.ctrl;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;

import pl.model.Person;
import pl.model.exception.UniquenessConstraintViolation;

public abstract class PersonController {
  @PersistenceContext( unitName="SubtypingApp")
  protected EntityManager em;
  @Resource protected UserTransaction ut;

  /**
   * UI specific check for the personId uniqueness constraint. It uses the
   * <code>Person.checkPersonIdsId</code> method to verify the existence in the
   * database of an person entry for the given personId value.
   * 
   * @param context
   *          the faces context - used by the system when the method is
   *          automatically called from JSF facelets.
   * @param component
   *          the UI component reference - used by the system when the method is
   *          automatically called from JSF facelets.
   * @param value
   *          the value to be checked - in this case is the personId to look for
   *          in the persons table
   * @throws ValidatorException
   */
  public void checkPersonIdAsId( FacesContext context, UIComponent component,
      Object value) throws ValidatorException {
    Integer personId = (Integer) value;
    try {
      Person.checkPersonIdAsId( em, personId);
    } catch ( UniquenessConstraintViolation e) {
      throw new ValidatorException( new FacesMessage(
          FacesMessage.SEVERITY_ERROR, e.getMessage(), e.getMessage()));
    }
  }
}