package pl.ctrl;

import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.persistence.EntityExistsException;

import pl.model.Author;
import pl.model.Person;

@SessionScoped @ManagedBean( name="authorCtrl")
public class AuthorController extends PersonController {

  /**
   * Read the list of all authors from the database.
   * 
   * @return an instance of all the author entries found in the database.
   */
  public List<Author> getAuthors() {
    return Author.retrieveAll( em);
  }

  /**
   * Update the reference object by setting its property values to match the one
   * existing in the database for the specific instance, identified by the
   * primary key value.
   **/
  public void refreshObject( Author author) {
    Author foundAuthor = Author.retrieve( em, author.getPersonId());
    author.setPersonId( foundAuthor.getPersonId());
    author.setName( foundAuthor.getName());
    author.setBiography( foundAuthor.getBiography());
  }

  /**
   * Create and persist a new Author instance.
   * 
   * @param personId
   *          the personId of the author to create
   * @param name
   *          the name of the author to create
   * @param biography
   *          the biography of the author to create
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String add( Integer personId, String name, String biography) {
    try {
      Author.add( em, ut, personId, name, biography);
      // Enforce clearing the form after creating the Author row.
      // Without this, the form will show the latest completed data
      FacesContext facesContext = FacesContext.getCurrentInstance();
      facesContext.getExternalContext().getRequestMap().remove( "author");
    } catch ( EntityExistsException e) {
      try {
        ut.rollback();
      } catch ( Exception e1) {
        e1.printStackTrace();
      }
      e.printStackTrace();
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "create";
  }

  /**
   * Update an Author instance.
   * 
   * @param personId
   *          the personId of the author to update
   * @param name
   *          the name of the author to update
   * @param biography
   *          the new value for biography property
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String update( Integer personId, String name, String biography) {
    try {
      Author.update( em, ut, personId, name, biography);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "update";
  }

  /**
   * Delete an Author entry from database.
   * 
   * @param personId
   *          the id of the author to delete - used to uniquely identify the
   *          author entry.
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   */
  public String destroy( Integer personId) {
    try {
      Person.destroy( em, ut, personId);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "delete";
  }
}
