package pl.model.validation;

import java.util.Calendar;
import java.util.Date;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UpToNextYearImpl implements
    ConstraintValidator<UpToNextYear, Integer> {
  private Calendar calendar;

  @Override
  public void initialize( UpToNextYear arg0) {
    this.calendar = Calendar.getInstance();
    calendar.setTime( new Date());
  }

  @Override
  public boolean isValid( Integer year, ConstraintValidatorContext context) {
    if ( year == null || year > this.calendar.get( Calendar.YEAR) + 1) {
      return false;
    }
    return true;
  }
}