/*
 * Copyright (c) 2014-2016 Cesanta Software Limited
 * All rights reserved
 */

#ifndef CS_MFT_SRC_SERIAL_H_
#define CS_MFT_SRC_SERIAL_H_

#include <QSerialPortInfo>

#include <common/util/statusor.h>

class QSerialPort;

util::StatusOr<QSerialPortInfo> findSerial(const QString &systemLocation);

util::StatusOr<QSerialPort *> connectSerial(const QSerialPortInfo &port,
                                            int speed = 115200);
util::StatusOr<QSerialPort *> connectSerial(const QString &systemLocation,
                                            int speed = 115200);

util::Status setSpeed(QSerialPort *port, int speed);

#endif /* CS_MFT_SRC_SERIAL_H_ */
